#ifndef MEMUTIL_H
#define MEMUTIL_H

#define WORD_AT_BYTE_OFFSET(a, i) (*(int *)((char *)a + i))

#define ALIGN_DOWN(n, block) ((n) & ~((block) - 1))
#define ALIGN_UP(n, block) ALIGN_DOWN((n) + (block) - 1, block)

static unsigned __inline__ swap_bytes(unsigned x) {
	return x << 24 | (x & 0xff00) << 8 | x >> 8 & 0xff00 | x >> 24;
}

#endif
