#include "kheap.h"

#define PAIR_SET(l, r) do { \
	l.value = r.value; \
	l.data = r.data; \
} while (0)

#define K 8

#define PARENT(i) (((i)-1)/K)
#define LEFT(i) (K*(i)+1)

int heap_insert(heap_t *heap, int value, int data) {
	if (heap->size == HEAP_CAPACITY)
		return 0;

	int i = heap->size;
	int p = PARENT(i);
	heap_node_t temp;

	heap->nodes[i].value = value;
	heap->nodes[i].data = data;
	heap->size++;

	while (i > 0 && heap->nodes[i].value < heap->nodes[p].value) {
		PAIR_SET(temp, heap->nodes[i]);
		PAIR_SET(heap->nodes[i], heap->nodes[p]);
		PAIR_SET(heap->nodes[p], temp);
		i = p;
		p = PARENT(i);
	}
	
	return 1;
}

int heap_remove(heap_t *heap, int *valuer, int *data) {
	if (heap->size == 0)
		return 0;

	*valuer = heap->nodes[0].value;
	*data = heap->nodes[0].data;
	heap->size--;
	PAIR_SET(heap->nodes[0], heap->nodes[heap->size]);
	
	int value = heap->nodes[0].value;
	int imin, imin_new = 0;
	do {
		int i;
		imin = imin_new;
		int first = LEFT(imin);
		int last = first + K;
		if (last > heap->size)
			last = heap->size;
		int count = last - first;
		int min = value;
		for (i = first; i < last; i++) {
			if (heap->nodes[i].value < min) {
				imin_new = i;
				min = heap->nodes[i].value;
			}
		}
		if (imin_new != imin) {
			heap_node_t temp;
			PAIR_SET(temp, heap->nodes[imin]);
			PAIR_SET(heap->nodes[imin], heap->nodes[imin_new]);
			PAIR_SET(heap->nodes[imin_new], temp);
		}
	} while (imin_new != imin);

	return 1;
}
