#ifndef FI_H
#define FI_H

#include "sum.h"

// Flag == 0 means begin a new group, flag == 1 means add to preceding element
typedef int flagged_int;
#define FI_FLAG 0x80000000
#define FI(x, flag) ((x) | ((flag) ? FI_FLAG : 0))
#define FI_GET_FLAG(x) (((x) & FI_FLAG) != 0)
#define FI_SET_FLAG(x) ((x) | FI_FLAG)
#define FI_CLEAR_FLAG(x) ((x) & ~FI_FLAG)
#define FI_ADD(x, y) (FI_GET_FLAG(y) ? (x) + FI_CLEAR_FLAG(y) : (y))

DECLARE_PREFIX_SUM(flagged_int);

#endif
