#ifndef BISTREAM_H
#define BISTREAM_H

typedef struct {
	int length;
	int pos;
	int *bits;
} bitstream_t;

void bitstream_init(bitstream_t *stream, int *bits, int capacity);
void bitstream_dup(bitstream_t *stream, bitstream_t *newstream, int offset);
void bitstream_slice(bitstream_t *stream, bitstream_t *newstream, int offset, int length);
void bitstream_rewind(bitstream_t *stream);
int bitstream_tell(bitstream_t *stream);
int bitstream_eof(bitstream_t *stream);
void bitstream_truncate(bitstream_t *stream);
int bitstream_read_bit(bitstream_t *stream);
int bitstream_write_bits(bitstream_t *stream, int bits, int n);

#endif
