#include "bitstream.h"

void bitstream_init(bitstream_t *stream, int *bits, int capacity) {
	stream->length = capacity;
	stream->pos = 0;
	stream->bits = bits;
}

void bitstream_dup(bitstream_t *stream, bitstream_t *newstream, int offset) {
	newstream->length = stream->length;
	newstream->pos = stream->pos + offset;
	newstream->bits = stream->bits;
}

void bitstream_slice(bitstream_t *stream, bitstream_t *newstream, int offset, int length) {
	int newpos = stream->pos + offset;
	int newlength = newpos + length;
	if (newlength > stream->length)
		newlength = stream->length;
	newstream->length = newlength;
	newstream->pos = newpos;
	newstream->bits = stream->bits;
}

void bitstream_rewind(bitstream_t *stream) {
	stream->pos = 0;
}

int bitstream_tell(bitstream_t *stream) {
	return stream->pos;
}

int bitstream_eof(bitstream_t *stream) {
	return stream->pos == stream->length;
}

void bitstream_truncate(bitstream_t *stream) {
	stream->length = stream->pos;
}

int bitstream_read_bit(bitstream_t *stream) {
	if (stream->pos == stream->length)
		return -1;
	int i = (unsigned)stream->pos >> 5;
	int shamt = stream->pos & 0x1f;
	stream->pos++;
	return stream->bits[i] >> shamt & 1;
}

int bitstream_write_bits(bitstream_t *stream, int bits, int n) {
	if (stream->pos + n > stream->length)
		return 0;
	int shamt = stream->pos & 0x1f;
	int remain = 32 - shamt;
	int written = 0;
	if (n > remain) {
		written = bitstream_write_bits(stream, bits, remain);
		bits >>= remain;
		shamt = 0;
		n -= remain;
	}
	int i = (unsigned)stream->pos >> 5;
	stream->bits[i] |= (bits & (1 << n) - 1) << shamt;
	stream->pos += n;
	return written + n;
}

