#ifndef KSPAWN_H
#define KSPAWN_H

#ifdef TRACE
#define TRACE_BEGIN \
	int _start; \
	int _end; \
	xmt_readtimer32(_start);
#define TRACE_END \
	xmt_readtimer32(_end); \
	printf("ks %s(%d): %d\n", __FILE__, __LINE__, _end-_start);
#ifdef PARALLEL_CYCLES
#define TRACE_END TRACE_END \
	parallel_cycles += _end - _start;
#endif

#elif defined(PARALLEL_CYCLES)
extern int parallel_cycles;
#define TRACE_BEGIN \
	int _start; \
	int _end; \
	xmt_readtimer32(_start);
#define TRACE_END \
	xmt_readtimer32(_end); \
	parallel_cycles += _end - _start;

#else
#define TRACE_BEGIN
#define TRACE_END

#endif

#ifdef USE_KSPAWN

#define begin_kspawn(lo, hi, k) { \
	TRACE_BEGIN \
	int _lo = (lo); \
	int _hi = (hi); \
	int _k = (k); \
	if (_lo < _hi) { \
		int _ubound = (_hi - _lo - 1) / _k; \
		int _ntcus; \
		getTCUID(_ntcus); \
		if (_ubound < _ntcus) { \
			_k = (_hi - _lo) / _ntcus; \
			if (_k == 0) \
				_k = 1; \
			_ubound = (_hi - _lo - 1) / _k; \
		} \
		spawn(0, _ubound) { \
			int _start = _k * $ + _lo; \
			int _end = _start + _k; \
			int $$; \
			if (_end > _hi) \
				_end = _hi; \
			for ($$ = _start; $$ < _end; $$++)

#define end_kspawn } } TRACE_END }

#else

#define $$ $

#define begin_kspawn(lo, hi, k) { \
	TRACE_BEGIN \
	int _lo = (lo); \
	int _hi = (hi); \
	if (_lo < _hi) spawn(_lo, _hi - 1)

#define end_kspawn TRACE_END }
#endif

#endif
